<?php namespace Visiosoft\SmsNetgsmExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;

class SmsNetgsmExtension extends Extension
{
    protected $provides = 'visiosoft.module.sms::provider.netgsm';

    public function send($number, $message)
    {
        $msg = html_entity_decode($message, ENT_COMPAT, "UTF-8");
        $msg = rawurlencode($msg);

        $header = setting_value('visiosoft.extension.sms_netgsm::header');
        $netgsmuser = setting_value('visiosoft.extension.sms_netgsm::user');
        $netgsmpassword = setting_value('visiosoft.extension.sms_netgsm::password');

        if (empty($header) || empty($netgsmuser) || empty($netgsmpassword)) {
            throw new \Exception(trans('visiosoft.module.sms::message.update_setting', ['name' => $this->name]), 400);
            die;
        }

        $number = str_replace("+","",$number);
        if($number[0]!=9){
            $number="00".$number;
        }

        $startdate = date('d.m.Y H:i');
        $startdate = str_replace('.', '', $startdate);
        $startdate = str_replace(':', '', $startdate);
        $startdate = str_replace(' ', '', $startdate);

        $stopdate = date('d.m.Y H:i', strtotime('+1 day'));
        $stopdate = str_replace('.', '', $stopdate);
        $stopdate = str_replace(':', '', $stopdate);
        $stopdate = str_replace(' ', '', $stopdate);

        $header = html_entity_decode($header, ENT_COMPAT, "UTF-8");
        $header = rawurlencode($header);

        $url = "http://api.netgsm.com.tr/bulkhttppost.asp?usercode=" . $netgsmuser . "&password=" . $netgsmpassword . "&gsmno=$number&message=$msg&msgheader=$header&startdate=$startdate&stopdate=$stopdate";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $output = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if (!$http_code === 200) {
            if ($http_code === 20) {
                throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.long_message'), 400);
            } elseif ($http_code === 30) {
                throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.invalid_user'), 400);
            } elseif ($http_code === 40) {
                throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.header_not_defined'), 400);
            } elseif ($http_code === 70) {
                throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.bad_parameter'), 400);
            } elseif ($http_code === 85) {
                throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.limit_overrun'), 400);
            } elseif ($http_code === 100 || $http_code === 101 || $http_code === 400) {
                throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.system_error'), 400);
            }
        }
    }
}
