<?php namespace Visiosoft\SmsNetgsmExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Visiosoft\TicketsModule\Ticket\Contract\TicketRepositoryInterface;

class SmsNetgsmExtension extends Extension
{
    protected $provides = 'visiosoft.module.sms::provider.netgsm';

    public function send($number, $message)
    {
        try {
            $msg = html_entity_decode($message, ENT_COMPAT, "UTF-8");
            $msg = rawurlencode($msg);

            $header = setting_value('visiosoft.extension.sms_netgsm::header');
            $netgsmuser = setting_value('visiosoft.extension.sms_netgsm::user');
            $netgsmpassword = setting_value('visiosoft.extension.sms_netgsm::password');

            if (empty($header) || empty($netgsmuser) || empty($netgsmpassword)) {
                throw new \Exception(trans('visiosoft.module.sms::message.update_setting', ['name' => $this->name]), 400);
            }

            $number = str_replace("+", "", $number);
            if ($number[0] != 9) {
                $number = "00" . $number;
            }

            $header = html_entity_decode($header, ENT_COMPAT, "UTF-8");
            $header = rawurlencode($header);

            $url = "http://api.netgsm.com.tr/bulkhttppost.asp?usercode=" . $netgsmuser . "&password=" . $netgsmpassword . "&gsmno=$number&message=$msg&msgheader=$header";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $output = curl_exec($ch);
            curl_close($ch);

            $serviceCode = substr($output, 0, 2);
            if ($serviceCode != 00) {
                $modules = app('module.collection')->installed();
                $provider = $modules->get('visiosoft.module.tickets');
                if ($provider) {
                    $ticketRepository = app(TicketRepositoryInterface::class);
                    $ticketData = [
                        'subject' => $number . ': ' . trans('visiosoft.extension.sms_netgsm::message.sms_not_sent'),
                        'status_id' => 1,
                        'department_id' => 2,
                        'ticket_number' => $ticketRepository->getTicketNumber(),
                        'priority_id' => 2,
                        'name' => $number
                    ];
                    $ticketRepository->create($ticketData);
                }
                //todo open new ticket.
                if ($serviceCode == 20) {
                    throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.long_message'), 400);
                } elseif ($serviceCode == 30) {
                    throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.invalid_user'), 400);
                } elseif ($serviceCode == 40) {
                    throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.header_not_defined'), 400);
                } elseif ($serviceCode == 70) {
                    throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.bad_parameter'), 400);
                } elseif ($serviceCode == 85) {
                    throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.limit_overrun'), 400);
                } elseif ($serviceCode == 100 || $serviceCode == 101 || $serviceCode == 400) {
                    throw new \Exception(trans('visiosoft.extension.sms_netgsm::message.system_error'), 400);
                }
            }
        } catch (\Exception $e) {
            if (app()->bound('sentry') && !empty(env('SENTRY_LARAVEL_DSN'))) {
                app('sentry')->captureException($e);
                throw new \Exception($e->getMessage());
            }
        }
    }
}
