<?php namespace Visiosoft\SmsModule\Template;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Support\Str;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class TemplateSeeder extends Seeder
{
    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
        parent::__construct();
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $templates = [
            [
                'en' => [
                    'name' => 'Approved Ad',
                    'message' => "{url} ilanınız yayınlandı.",
                ],
                'slug' => Str::slug('Approved Ad', '_')
            ],
            [
                'en' => [
                    'name' => 'Declined Ad',
                    'message' => "{url} ilanınız ilan verme kurallarına uymadığı için reddedilmiştir.",
                ],
                'slug' => Str::slug('Declined Ad', '_')
            ],
            [
                'en' => [
                    'name' => 'Pending User Ad',
                    'message' => "{url} ilanınızı gözden geçirip onaylamanız gerekmektedir.",
                ],
                'slug' => Str::slug('Pending User Ad', '_')
            ],
            [
                'en' => [
                    'name' => 'Pending Ad',
                    'message' => "{url} ilanınız editörlerimiz tarafından kontrol edilmektedir.",
                ],
                'slug' => Str::slug('Pending Ad', '_')
            ],
            [
                'en' => [
                    'name' => 'Registered User',
                    'message' => "{first_name} {last_name} üyeliğiniz başarıyla oluşturuldu.",
                ],
                'slug' => Str::slug('Registered User', '_')
            ],
            [
                'en' => [
                    'name' => 'Forgot Password Sms',
                    'message' => "Şifreniz sıfırlandı.Yeni şifreniz:{password}",
                ],
                'slug' => Str::slug('Forgot Password Sms', '_')
            ],
            [
                'en' => [
                    'name' => 'Reminding Tomorrow For Booking',
                    'message' => "Booking Reminding!. Location:{location}, Service:{service}, Staff:{staff}, Date:{date}",
                ],
                'slug' => Str::slug('Reminding Tomorrow For Booking', '_'),
                'isactive' => true,
            ],
            [
                'en' => [
                    'name' => 'Reservation Created',
                    'message' => "Reservation created for {name}!. Location:{location}, Service:{service}, Staff:{staff}, Date:{date}",
                ],
                'slug' => Str::slug('Reservation Created', '_'),
                'isactive' => true,
            ],
            [
                'en' => [
                    'name' => 'Reservation activation',
                    'message' => "Reservation created for {date} ({name}). Please Activate Reservation : {url}",
                ],
                'slug' => Str::slug('Reservation activation', '_'),
                'isactive' => true,
            ],
            [
                'en' => [
                    'name' => 'Activate Gsm Sms',
                    'message' => "Your gsm activation code is {code}",
                ],
                'slug' => 'activate_gsm_sms',
                'isactive' => true,
            ],
        ];

        $slugs = array_column($templates, 'slug');
        $exists = $this->template->getExistedSlugsBySlugs($slugs);
        $templates = array_filter($templates, function ($template) use ($exists) {
            return !in_array($template['slug'], $exists);
        });

        foreach ($templates as $template) {
            $this->template->create($template);
        }
    }
}
