<?php namespace Visiosoft\SmsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\BookingModule\Booking\Events\ActivationBooking;
use Visiosoft\BookingModule\Booking\Events\CreateBooking;
use Visiosoft\BookingModule\Booking\Events\remindingTomorrow;
use Visiosoft\ImportModule\Events\SendPasswordSMS;
use Visiosoft\ProfileModule\Profile\Events\SendForgotPasswordSms;
use Visiosoft\SmsModule\Listeners\ActivateGsmSms;
use Visiosoft\SmsModule\Listeners\activationBookingSMS;
use Visiosoft\SmsModule\Listeners\ForgotPasswordSms;
use Visiosoft\SmsModule\Listeners\PasswordSMS;
use Visiosoft\SmsModule\Listeners\RegisteredUser;
use Visiosoft\SmsModule\Listeners\remindingTomorrowSms;
use Visiosoft\SmsModule\Listeners\reservationCreated;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\SmsModule\Template\TemplateRepository;
use Anomaly\Streams\Platform\Model\Sms\SmsTemplateEntryModel;
use Visiosoft\SmsModule\Template\TemplateModel;
use Visiosoft\AdvsModule\Adv\Event\ChangedStatusAd;
use Visiosoft\AdvsModule\Adv\Event\CreatedAd;
use Visiosoft\SmsModule\Listeners\ChangeStatusAdSms;
use Visiosoft\SmsModule\Listeners\CreatedAdSms;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Log\LogRepository;
use Anomaly\Streams\Platform\Model\Sms\SmsLogsEntryModel;
use Visiosoft\SmsModule\Log\LogModel;
use Visiosoft\SmsVerificationModule\Events\GsmVerification;

class SmsModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/sms/template' => 'Visiosoft\SmsModule\Http\Controller\Admin\TemplateController@index',
        'admin/sms/template/create' => 'Visiosoft\SmsModule\Http\Controller\Admin\TemplateController@create',
        'admin/sms/template/edit/{id}' => 'Visiosoft\SmsModule\Http\Controller\Admin\TemplateController@edit',
        'admin/sms/testsms' => 'Visiosoft\SmsModule\Http\Controller\Admin\TemplateController@TestSms',
        'admin/sms' => 'Visiosoft\SmsModule\Http\Controller\Admin\LogsController@index',
    ];

    protected $listeners = [
        CreatedAd::class => [
            CreatedAdSms::class
        ],
        ChangedStatusAd::class => [
            ChangeStatusAdSms::class
        ],
        UserHasRegistered::class => [
            RegisteredUser::class
        ],
        SendForgotPasswordSms::class => [
            ForgotPasswordSms::class
        ],
        GsmVerification::class => [
            ActivateGsmSms::class
        ],

        //Booking
        remindingTomorrow::class => [
            remindingTomorrowSms::class
        ],
        CreateBooking::class => [
            reservationCreated::class
        ],

        ActivationBooking::class => [
            activationBookingSMS::class
        ],
        SendPasswordSMS::class => [
            PasswordSMS::class
        ],
    ];

    protected $bindings = [
        SmsTemplateEntryModel::class => TemplateModel::class,
        SmsLogsEntryModel::class => LogModel::class,
    ];

    protected $singletons = [
        TemplateRepositoryInterface::class => TemplateRepository::class,
        LogRepositoryInterface::class => LogRepository::class,
    ];
}
