<?php namespace Visiosoft\SmsModule\Template\TestSms;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class TestSmsFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'phone' => [
            'label' => 'visiosoft.module.sms::field.number.name',
            'type' => 'anomaly.field_type.text',
            'placeholder' => '905301234567'
        ],
        'message' => [
            'label' => 'visiosoft.module.sms::field.message.name',
            'type' => 'anomaly.field_type.text',
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'save' => [
            'text' => 'visiosoft.module.sms::button.send_sms',
            'icon' => '',
            'type' => 'info'
        ],
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin/sms',
        'success_message' => false,
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
