<?php namespace Visiosoft\SmsModule\Template;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Str;
use Visiosoft\SmsModule\Template\Command\SmsTemplateCreator;

class TemplateSeeder extends Seeder
{
    use DispatchesJobs;

    public function run()
    {
        $templates = [
            [
                'en' => [
                    'name' => 'Registered User',
                    'message' => "{first_name} {last_name} üyeliğiniz başarıyla oluşturuldu.",
                ],
                'slug' => Str::slug('Registered User', '_')
            ],
            [
                'en' => [
                    'name' => 'Forgot Password Sms',
                    'message' => "Şifreniz sıfırlandı.Yeni şifreniz:{password}",
                ],
                'slug' => Str::slug('Forgot Password Sms', '_')
            ],
            [
                'en' => [
                    'name' => 'Reminding Tomorrow For Booking',
                    'message' => "Booking Reminding!. Location:{location}, Service:{service}, Staff:{staff}, Date:{date}",
                ],
                'slug' => Str::slug('Reminding Tomorrow For Booking', '_'),
                'isactive' => true,
            ],
            [
                'en' => [
                    'name' => 'Reservation Created',
                    'message' => "Reservation created for {name}!. Location:{location}, Service:{service}, Staff:{staff}, Date:{date}",
                ],
                'slug' => Str::slug('Reservation Created', '_'),
                'isactive' => true,
            ],
            [
                'en' => [
                    'name' => 'Reservation activation',
                    'message' => "Reservation created for {date} ({name}). Please Activate Reservation : {url}",
                ],
                'slug' => Str::slug('Reservation activation', '_'),
                'isactive' => true,
            ],
            [
                'en' => [
                    'name' => 'Activate Gsm Sms',
                    'message' => "Your gsm activation code is {code}",
                ],
                'slug' => 'activate_gsm_sms',
                'isactive' => true,
            ],
            [
                'en' => [
                    'name' => 'One time password',
                    'message' => "Welcome to Ocify your verification code is: {{code}}",
                ],
                'slug' => 'activate_gsm_sms',
                'isactive' => true,
            ]
        ];

        foreach ($templates as $template) {
            $this->dispatch(new SmsTemplateCreator($template));
        }
    }
}
