<?php namespace Visiosoft\SmsModule\Template;

use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TemplateRepository extends EntryRepository implements TemplateRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var TemplateModel
     */
    protected $model;

    /**
     * Create a new TemplateRepository instance.
     *
     * @param TemplateModel $model
     */
    public function __construct(TemplateModel $model)
    {
        $this->model = $model;
    }

    public function findBySlug($slug)
    {
        return $this->newQuery()->where('slug', $slug)->first();
    }

    public function getExistedSlugsBySlugs($slugs)
    {
        return $this->getModel()->whereIn('slug', $slugs)->pluck('slug')->all();
    }
}
