<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\BookingModule\Booking\Events\remindingTomorrow;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class remindingTomorrowSms
{

    private $sms;
    private $user;
    private $template;
    private $log;

    public function __construct(
        UserRepositoryInterface $user,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->netgsm = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->user = $user;
        $this->template = $template;
        $this->log = $log;

    }

    public function handle(remindingTomorrow $event)
    {
        $sms_service_type = setting_value('visiosoft.module.sms::selected_service');
        $booking_detail = array_merge($event->getBooking()->toArray(), [
            'service' => $event->getService()->name,
            'location' => $event->getLocation()->name,
            'staff' => $event->getStaff()->name,
            'date' => $event->getBooking()->booking_datetime_start . " - " . $event->getBooking()->booking_datetime_end,
        ]);

        if (!is_null($phone = $booking_detail['phone'])) {
            $template = $this->template->findBySlug('reminding_tomorrow_for_booking');
            if (!is_null($template) and $template->isactive == 1) {
                $template = $template->getTemplateForArray($booking_detail);
                $msg = $template['message'];
                $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
                $msg = rawurlencode($msg);
                try {
                    $this->{$sms_service_type}->sendSMS($msg, $phone);
                    $this->log->createLog($phone, $msg, $event->getBooking());
                } catch (\Exception $e) {}
            }
        }
    }
}
