<?php namespace Visiosoft\SmsModule\Listeners;

use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\SmsVerificationModule\Events\GsmVerification;

class ActivateGsmSms
{
    private $sms;
    private $log;
    private $template;

    public function __construct(
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->sms = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->log = $log;
        $this->template = $template;
    }

    public function handle(GsmVerification $event)
    {
        $user = $event->getActivation()->user;
        if ($phone = $user->gsm_phone) {
            $template = $this->template->findBySlug('activate_gsm_sms');

            if ($template && $template->isactive) {
                $template = $template->getTemplateForArray([
                    'code' => $event->getActivation()->code
                ]);
                $msg = $template['message'];
                $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
                $msg = rawurlencode($msg);
                $this->sms->sendSMS($msg, $phone);
                $this->log->createLog($phone, $msg, $user);
            }
        }
    }
}
