<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\BookingModule\Booking\Events\CreateBooking;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class reservationCreated
{

    private $sms;
    private $user;
    private $template;
    private $log;

    public function __construct(
        UserRepositoryInterface $user,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->sms = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->user = $user;
        $this->template = $template;
        $this->log = $log;

    }

    public function handle(CreateBooking $event)
    {
        $booking_detail = array_merge($event->detail()->toArray(), [
            'service' => $event->service()->name,
            'location' => $event->location()->name,
            'staff' => $event->staff()->name,
            'date' => $event->detail()->booking_datetime_start . " - " . $event->detail()->booking_datetime_end,
        ]);

            if (!is_null($phone = $booking_detail['admin_notification_phone'])) {
                $template = $this->template->findBySlug('reservation_created')->getTemplateForArray($booking_detail);
                if (!is_null($template) and $template['isactive'] == 1) {
                    $msg = $template['message'];
                    $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
                    $msg = rawurlencode($msg);
                    $this->sms->sendSMS($msg, $phone);
                    $this->log->createLog($phone, $msg, $event->detail());
                }
            }

    }
}
