<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class RegisteredUser
{

    private $sms;
    private $user;
    private $ad;
    private $template;
    private $log;

    public function __construct(
        UserRepositoryInterface $user,
        AdvModel $ad,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->sms = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->user = $user;
        $this->ad = $ad;
        $this->template = $template;
        $this->log = $log;

    }

    public function handle(UserHasRegistered $event)
    {
        $user = $event->getUser();
        if (!is_null($phone = $user->gsm_phone)) {
            $template = $this->template->findBySlug('registered_user');
            if ($template AND $template->toArray()['isactive'] == 1) {
                $template = $template->getTemplateForArray($user->toArray());
                if(!is_null($template)) {
                    $msg = $template['message'];
                    $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
                    $msg = rawurlencode($msg);
                    $this->sms->sendSMS($msg, $phone);
                    $this->log->createLog($phone, $msg, $user);
                }
            }
        }
    }
}
