<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\ProfileModule\Profile\Events\SendForgotPasswordSms;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class ForgotPasswordSms
{

    private $sms;
    private $user;
    private $ad;
    private $log;
    private $template;

    public function __construct(
        UserRepositoryInterface $user,
        AdvModel $ad,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->sms = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->user = $user;
        $this->ad = $ad;
        $this->log = $log;
        $this->template = $template;
    }

    public function handle(SendForgotPasswordSms $event)
    {
        $user = $event->user();
        if (!is_null($phone = $user->gsm_phone)) {
            $userArray = $user->toArray();
            $userArray['password'] = $event->password();
            $template = $this->template->findBySlug('forgot_password_sms');

            if ($template AND $template->toArray()['isactive'] == 1) {
                $template = $template->getTemplateForArray($userArray);
                if (!is_null($template)) {
                    $msg = $template['message'];
                    $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
                    $msg = rawurlencode($msg);
                    $this->sms->sendSMS($msg, $phone);
                    $this->log->createLog($phone, $msg, $user);
                }
            }
        }
    }
}
