<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Event\CreatedAd;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class CreatedAdSms
{

    private $sms;
    private $user;
    private $ad;
    private $template;
    private $log;

    public function __construct(
        UserRepositoryInterface $user,
        AdvModel $ad,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->sms = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->user = $user;
        $this->ad = $ad;
        $this->template = $template;
        $this->log = $log;

    }

    public function handle(CreatedAd $event)
    {
        $ad = $event->getAdDetail();
        $user = $this->user->find($ad->created_by_id);

        if (!is_null($phone = $user->gsm_phone)) {

            if ($ad->status == "approved") {
                $msg = $this->template->findBySlug('approved_ad');
            } elseif ($ad->status == "pending_user") {
                $msg = $this->template->findBySlug('pending_user_ad');
            } else {
                $msg = $this->template->findBySlug('pending_ad');
            }
            if($msg AND $msg->toArray()['isactive'] == 1) {
                $msg = $msg->getMessage($ad);
                if (!is_null($msg)) {
                    $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
                    $msg = rawurlencode($msg);
                    $this->sms->sendSMS($msg, $phone);
                    $this->log->createLog($phone, $msg, $ad);
                }
            }

        }
    }
}
