<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\SmsModule\Commands\SendSms;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class RegisteredUser
{
    private $user;
    private $ad;
    private $template;
    private $log;

    public function __construct(
        UserRepositoryInterface $user,
        AdvModel $ad,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->user = $user;
        $this->ad = $ad;
        $this->template = $template;
        $this->log = $log;

    }

    public function handle(UserHasRegistered $event)
    {
        $user = $event->getUser();
        if (!is_null($phone = $user->gsm_phone)) {
            $template = $this->template->findBySlug('registered_user');
            if (!is_null($template) and $template->isactive == 1) {
                $template = $template->getTemplateForArray($user->toArray());
                $msg = $template['message'];
                dispatch(new SendSms($phone, $msg));
                $this->log->createLog($phone, $msg, $user);
            }
        }
    }
}
