<?php namespace Visiosoft\SmsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\SmsModule\Template\TemplateRepository;
use Anomaly\Streams\Platform\Model\Sms\SmsTemplateEntryModel;
use Visiosoft\SmsModule\Template\TemplateModel;
use Visiosoft\AdvsModule\Adv\Event\ChangedStatusAd;
use Visiosoft\AdvsModule\Adv\Event\CreatedAd;
use Visiosoft\SmsModule\Listeners\ChangeStatusAdSms;
use Visiosoft\SmsModule\Listeners\CreatedAdSms;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Log\LogRepository;
use Anomaly\Streams\Platform\Model\Sms\SmsLogsEntryModel;
use Visiosoft\SmsModule\Log\LogModel;
use Illuminate\Routing\Router;

class SmsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/sms/template'           => 'Visiosoft\SmsModule\Http\Controller\Admin\TemplateController@index',
        'admin/sms/template/create'    => 'Visiosoft\SmsModule\Http\Controller\Admin\TemplateController@create',
        'admin/sms/template/edit/{id}' => 'Visiosoft\SmsModule\Http\Controller\Admin\TemplateController@edit',
        'admin/sms/testsms' => 'Visiosoft\SmsModule\Http\Controller\Admin\TemplateController@TestSms',
        'admin/sms' => 'Visiosoft\SmsModule\Http\Controller\Admin\LogsController@index',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\SmsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\SmsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        CreatedAd::class => [
            CreatedAdSms::class
        ],
        ChangedStatusAd::class => [
            ChangeStatusAdSms::class
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\SmsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        SmsTemplateEntryModel::class => TemplateModel::class,
        SmsLogsEntryModel::class => LogModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        TemplateRepositoryInterface::class => TemplateRepository::class,
        LogRepositoryInterface::class => LogRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
