<?php namespace Visiosoft\SmsModule\Template;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class TemplateSeeder extends Seeder
{
    private $template;

    public function __construct(TemplateRepositoryInterface $template)
    {
        $this->template = $template;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $this->template->create([
            'en' => [
                'name' => 'Approved Ad',
                'message' => "{url} ilanınız yayınlandı.",
            ],
            'slug' => str_slug('Approved Ad')
        ]);
        $this->template->create([
            'en' => [
                'name' => 'Declined Ad',
                'message' => "{url} ilanınız ilan verme kurallarına uymadığı için reddedilmiştir.",
            ],
            'slug' => str_slug('Declined Ad')
        ]);
        $this->template->create([
            'en' => [
                'name' => 'Pending User Ad',
                'message' => "{url} ilanınızı gözden geçirip onaylamanız gerekmektedir.",
            ],
            'slug' => str_slug('Pending User Ad')
        ]);
        $this->template->create([
            'en' => [
                'name' => 'Pending Ad',
                'message' => "{url} ilanınız editörlerimiz tarafından kontrol edilmektedir.",
            ],
            'slug' => str_slug('Pending Ad')
        ]);

        $this->template->create([
            'en' => [
                'name' => 'Registered User',
                'message' => "{first_name} {last_name} üyeliğiniz başarıyla oluşturuldu.",
            ],
            'slug' => str_slug('Registered User')
        ]);

        $this->template->create([
            'en' => [
                'name' => 'Forgot Password Sms',
                'message' => "Şifreniz sıfırlandı.Yeni şifreniz:{password}",
            ],
            'slug' => str_slug('Forgot Password Sms')
        ]);

    }
}
