<?php namespace Visiosoft\SmsModule\Template;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\SmsModule\Template\Contract\TemplateInterface;
use Anomaly\Streams\Platform\Model\Sms\SmsTemplateEntryModel;

class TemplateModel extends SmsTemplateEntryModel implements TemplateInterface
{
    public function getMessage($ad)
    {
        if (!is_null($this)) {
            $msg = $this->message;
            $msg = str_replace('{url}', $this->createAdLink($ad), $msg);
            $msg = str_replace('{id}', $ad->id, $msg);
            $msg = str_replace('{name}', $ad->name, $msg);
            return $msg;
        }
        return null;
    }

    public function createAdLink($ad)
    {
        $adModel = new AdvModel();
        return $adModel->getAdvDetailLinkByModel($ad, 'list');
    }

    public function getTemplateForArray(array $array)
    {
        if (!is_null($this)) {
            $template = $this->toArray();
            foreach ($template as $key => $item) {
                $variables = $this->getInbetweenStrings('{', '}', $template[$key]);

                foreach ($variables as $variable) {
                    if (isset($array[$variable])) {
                        $template[$key] = str_replace('{' . $variable . '}', $array[$variable], $template[$key]);
                    }
                }
            }
            return $template;
        }
        return null;
    }

    public function getInbetweenStrings($start, $end, $str)
    {
        $matches = array();
        $regex = "/$start([a-zA-Z0-9_]*)$end/";
        preg_match_all($regex, $str, $matches);
        return $matches[1];
    }
}
