<?php namespace Visiosoft\SmsModule\Commands;

use Visiosoft\SmsModule\Log\LogRepository;

class SendSms
{
    protected $number;
    protected $message;

    public function __construct($number, $message)
    {
        $this->number = $number;
        $this->message = $message;
    }

    public function handle(LogRepository $repository)
    {
        $extensions = app('extension.collection')->installed();

        $provider = setting_value('visiosoft.module.sms::selected_service');

        if (!$provider = $extensions->get($provider)) {
            throw new \Exception(trans('visiosoft.module.sms::message.provider_not_found'), 404);
            die;
        }

        if (!method_exists($provider, 'send')) {
            throw new \Exception(trans('visiosoft.module.sms::message.error_send'), 404);
            die;
        }

        $provider->send($this->number, $this->message);

        $repository->createLog($this->number, $this->message);
    }
}
