<?php

use Anomaly\SelectFieldType\SelectFieldType;
use Anomaly\Streams\Platform\Addon\Extension\ExtensionCollection;

return [
    'selected_service' => [
        "type" => "anomaly.field_type.select",
        'config' => [
            "config" => [
                "options" => function (SelectFieldType $fieldType, ExtensionCollection $extensions) {

                    $sms_providers = $extensions->search('visiosoft.module.sms::provider.*')
                        ->pluck('name', 'namespace')->all();

                    $fieldType->setOptions($sms_providers);
                },
            ],
        ],
    ],
];
