<?php namespace Visiosoft\SmsModule\Log;

use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class LogRepository extends EntryRepository implements LogRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var LogModel
     */
    protected $model;

    /**
     * Create a new LogRepository instance.
     *
     * @param LogModel $model
     */
    public function __construct(LogModel $model)
    {
        $this->model = $model;
    }

    public function createLog($number, $msg, $entry = null)
    {
        $log = $this->create([
            'number' => $number,
            'message' => $msg,
        ]);
        if (!is_null($entry)) {
            $log->entry = $entry;
            $log->save();
        }
    }
}
