<?php namespace Visiosoft\SmsModule\Template\MultipleSms;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\UsersModule\User\UserModel;

class MultipleSmsFormBuilder extends FormBuilder
{

    protected $model = UserModel::class;

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'users' => [
            'label' => 'visiosoft.module.sms::field.users.name',
            'type' => 'anomaly.field_type.multiple',
            'config' => [
                "related" => UserModel::class,
                "mode" => "lookup",
            ]
        ],
        'message' => [
            'label' => 'visiosoft.module.sms::field.message.name',
            'type' => 'anomaly.field_type.text',
        ],
        'phones' => [
            'label' => 'visiosoft.module.sms::field.phones.name',
            'instructions' => '+905219876543 Formatında Giriniz',
            'type' => 'anomaly.field_type.tags',
        ]
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [
        'save' => [
            'text' => 'visiosoft.module.sms::button.send_sms',
            'icon' => '',
            'type' => 'info'
        ],
    ];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin/sms',
        'success_message' => 'visiosoft.module.sms::message.adress_success_create',
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [];

}
