<?php namespace Visiosoft\SmsModule\Listeners;

use Visiosoft\SmsModule\Commands\SendSms;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class ActivateWithPhone
{
    private $log;
    private $template;

    public function __construct(
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->log = $log;
        $this->template = $template;
    }

    public function handle(\Anomaly\UsersModule\User\Event\ActivateWithPhone $event)
    {
        $user = $event->getUser();

        $template = $this->template->findBySlug('register_phone');

        if ($template && $template->isactive) {

            $template = $template->getTemplateForArray([
                'code' => $user->activation_code
            ]);

            $msg = $template['message'];

            dispatch(new SendSms($user->phone, $msg));
        }
    }
}
