<?php namespace Visiosoft\SmsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Visiosoft\SmsModule\Log\Table\LogTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class LogsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param LogTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(LogTableBuilder $table)
    {
        $table->setColumns([
            'number',
            'message' => [
                'value' => function(EntryModel $entry) {
                    return urldecode($entry->message);
                }
            ]
            ,'entry',
            'created_at' => 'entry.created_at'
        ]);
        return $table->render();

    }
}
