<?php namespace Visiosoft\SmsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;

class SmsController extends PublicController
{

    private $logRepository;

    public function __construct(
        LogRepositoryInterface $logRepository
    )
    {
        $this->logRepository = $logRepository;
    }

    public function smsHandler($number, $message, $fromModule)
    {
        // Check if service is selected
        $usedService = setting_value('visiosoft.module.sms::selected_service');
        if ($usedService != '') {
            $number = $this->numberValidation($number);
            // Log the sms to the Logs Model
            $this->logSms($number, $message, $fromModule, $usedService);
            $this->sendSms($number, $message, $usedService);
        }
    }

    public function numberValidation($number)
    {
        // Check if number starts with '+' or '00'
        if (strpos($number, '+') === 0) {
            $number = substr($number, 1);
        } elseif (strpos($number, '00') === 0) {
            $number = substr($number, 2);
        }
        // Check if number starts with '90'
        $number = strpos($number, '90') === 0 ? $number : '90' . $number;
        return $number;
    }

    public function sendSms($number, $message, $usedService)
    {
        $smsController = app('Visiosoft\NetgsmModule\Http\Controller\\'.$usedService.'Controller');
        $smsController->handleMessage($message, $number);
    }

    public function logSms($number, $message, $fromModule, $usedService)
    {
        $this->logRepository->create([
            'number' => $number,
            'message' => $message,
            'from_module' => $fromModule,
            'used_service' => $usedService
        ]);
    }
}
