<?php namespace Visiosoft\SmsModule\Template\MultipleSms;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SmsModule\Commands\SendSms;

class MultipleSmsFormHandler
{
    public function handle(MultipleSmsFormBuilder $builder, MessageBag $messageBag, UserRepositoryInterface $userRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $userIds = explode(',', $builder->getPostValue('users'));
        $users = $userRepository->findAll($userIds);
        $message = $builder->getPostValue('message');

        foreach ($users as $user) {
            try {
                if ($user->gsm_phone) {
                    dispatch(new SendSms($user->gsm_phone, $message));
                }
            } catch (\Exception $exception) {
                $messageBag->error([$exception->getMessage()]);
            }
        }

    }
}
