<?php namespace Visiosoft\SmsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\SmsModule\Template\TemplateSeeder;

class SmsModuleSeeder extends Seeder
{
    public function run()
    {
        $this->call(TemplateSeeder::class);

        $installed_modules = app('module.collection')->installed();
        $installed_modules = $installed_modules->merge(app('extension.collection')->installed());

        foreach ($installed_modules as $item) {

            $class = $item->getTransformedClass() . '\SmsSeeder\SmsSeeder';

            if (class_exists($class))
                $this->call($class);
        }
    }
}
