<?php namespace Visiosoft\SmsModule\Listeners;

use Visiosoft\ImportModule\Events\SendPasswordSMS;
use Visiosoft\SmsModule\Commands\SendSms;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class PasswordSMS
{

    private $log;
    private $template;

    public function __construct(
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->log = $log;
        $this->template = $template;
    }

    public function handle(SendPasswordSMS $event)
    {
        $user = $event->user();
        if ($phone = $user->gsm_phone) {
            $userArray = $user->toArray();
            $userArray['password'] = $event->password();

            if (($template = $this->template->findBySlug('forgot_password_sms')) && $template->isactive) {
                $template = $template->getTemplateForArray($userArray);
                $msg = $template['message'];
                dispatch(new SendSms($phone, $msg));
                $this->log->createLog($phone, $msg, $user);
            }
        }
    }
}
