<?php namespace Visiosoft\SmsModule\Listeners;

use Visiosoft\SmsModule\Commands\SendSms;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\SmsVerificationModule\Events\GsmVerification;

class ActivateGsmSms
{
    private $log;
    private $template;

    public function __construct(
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->log = $log;
        $this->template = $template;
    }

    public function handle(GsmVerification $event)
    {
        $user = $event->getActivation()->user;
        if ($phone = $user->gsm_phone) {
            $template = $this->template->findBySlug('activate_gsm_sms');

            if ($template && $template->isactive) {
                $template = $template->getTemplateForArray([
                    'code' => $event->getActivation()->code
                ]);
                $msg = $template['message'];

                dispatch(new SendSms($phone, $msg));
            }
        }
    }
}
