<?php namespace Visiosoft\SmsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\SmsModule\Template\Form\TemplateFormBuilder;
use Visiosoft\SmsModule\Template\Table\TemplateTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\SmsModule\Template\TestSms\TestSmsFormBuilder;
use Visiosoft\SmsModule\Template\MultipleSms\MultipleSmsFormBuilder;

class TemplateController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param TemplateTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(TemplateTableBuilder $table)
    {
        $table->setColumns([
            'name',
            'message',
            'isactive' => [
                'value' => function (EntryInterface $entry) {
                    if( $entry->isactive == 1) {
                        return trans("visiosoft.module.sms::field.active.name");
                    } else {
                        return trans("visiosoft.module.sms::field.passive.name");
                    }
                },
            ]
            ]);

        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param TemplateFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(TemplateFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param TemplateFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(TemplateFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function TestSms(TestSmsFormBuilder $builder)
    {
        return $builder->render();
    }

    public function MultipleSms(MultipleSmsFormBuilder $builder)
    {
        return $builder->render();
    }
}
