<?php namespace Visiosoft\SmsModule\Template\MultipleSms;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SmsModule\Commands\SendSms;

class MultipleSmsFormHandler
{
    public function handle(MultipleSmsFormBuilder $builder, MessageBag $messageBag, UserRepositoryInterface $userRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        $userIds = explode(',', $builder->getPostValue('users'));
        $users = $userRepository->findAll($userIds);
        $phones_array = json_decode($builder->getPostValue('phones'), true);
        if ($phones_array) {
            $phones = array_column($phones_array, 'value');
        }
        $message = $builder->getPostValue('message');

        foreach ($users as $user) {
            if ($user->gsm_phone) {
                $phones[] = $user->gsm_phone;
            }
        }

        foreach ($phones as $phone) {
            try {
                dispatch(new SendSms($phone, $message));
            } catch (\Exception $exception) {
                $messageBag->error([$exception->getMessage()]);
            }
        }

    }
}
