<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Event\CreatedAd;
use Visiosoft\SmsModule\Commands\SendSms;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class CreatedAdSms
{

    private $user;
    private $ad;
    private $template;
    private $log;

    public function __construct(
        UserRepositoryInterface $user,
        AdvModel $ad,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->user = $user;
        $this->ad = $ad;
        $this->template = $template;
        $this->log = $log;

    }

    public function handle(CreatedAd $event)
    {
        $ad = $event->getAdDetail();
        $user = $this->user->find($ad->created_by_id);

        if (!is_null($phone = $user->gsm_phone)) {

            if ($ad->status == "approved") {
                $msg = $this->template->findBySlug('approved_ad');
            } elseif ($ad->status == "pending_user") {
                $msg = $this->template->findBySlug('pending_user_ad');
            } else {
                $msg = $this->template->findBySlug('pending_ad');
            }
            if (!is_null($msg) and $msg->isactive == 1) {
                $msg = $msg->getMessage($ad);
                dispatch(new SendSms($phone, $msg));
                $this->log->createLog($phone, $msg, $ad);
            }
        }
    }
}
