<?php namespace Visiosoft\SmsModule\Template\TestSms;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\SmsModule\Commands\SendSms;

class TestSmsFormHandler
{
    public function handle(TestSmsFormBuilder $builder, MessageBag $messageBag)
    {
        if (!$builder->canSave()) {
            return;
        }

        $number = $builder->getPostValue('phone');
        $message = $builder->getPostValue('message');

        try {
            dispatch(new SendSms($number, $message));
        } catch (\Exception $exception) {
            $messageBag->error([$exception->getMessage()]);
        }
    }
}
