<?php namespace Visiosoft\SmsModule\Template\TestSms;

use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;

class TestSmsFormHandler
{
    public function handle(TestSmsFormBuilder $builder,LogRepositoryInterface $log)
    {
        if (!$builder->canSave()) {
            return;
        }
        $phone = $builder->getPostValue('phone');
        $message = $builder->getPostValue('message');
        $sms = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $msg = html_entity_decode($message, ENT_COMPAT, "UTF-8");
        $msg = rawurlencode($msg);
        $sms->sendSMS($msg, $phone);
        $log->createLog($phone, $msg);
    }
}
