<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\BookingModule\Booking\Events\CreateBooking;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class reservationCreated
{

    private $user;
    private $template;
    private $log;

    public function __construct(
        UserRepositoryInterface $user,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->netgsm = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->websms = app(\Visiosoft\WebsmsModule\Http\Controller\WebsmsController::class);
        $this->user = $user;
        $this->template = $template;
        $this->log = $log;

    }

    public function handle(CreateBooking $event)
    {

        $sms_service_type = setting_value('visiosoft.module.sms::selected_service');

        $booking_start = date("Y/m/d H:i", strtotime($event->detail()->booking_datetime_start));
        $booking_end = date("H:i", strtotime($event->detail()->booking_datetime_end));


        $booking_detail = array_merge($event->detail()->toArray(), [
            'service' => $event->service()->name,
            'location' => $event->location()->name,
            'staff' => $event->staff()->name,
            'date' => $booking_start . "-" . $booking_end,
        ]);

        if ($template = $this->template->findBySlug('reservation_created')) {
            $template = $template->getTemplateForArray($booking_detail);

            if ($template['isactive'] == 1) {
                $msg = $template['message'];
                try {
                    $this->{$sms_service_type}->sendSMS($msg, $booking_detail['phone']);
                    $this->log->createLog($booking_detail['phone'], $msg, $event->detail());
                } catch (\Exception $e) {}
            }
        }

    }
}
