<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Event\ChangedStatusAd;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class ChangeStatusAdSms
{

    private $sms;
    private $user;
    private $log;
    private $template;

    public function __construct(
        UserRepositoryInterface $user,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->sms = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->user = $user;
        $this->log = $log;
        $this->template = $template;
    }

    public function handle(ChangedStatusAd $event)
    {
        $ad = $event->getAdDetail();
        $user = $this->user->find($ad->created_by_id);

        if ($user && !is_null($phone = $user->gsm_phone)) {
            if ($ad->status == "approved") {
                $msg = $this->template->findBySlug('approved_ad');
            } elseif ($ad->status == "declined") {
                $msg = $this->template->findBySlug('declined_ad');
            } elseif ($ad->status == "pending_user") {
                $msg = $this->template->findBySlug('pending_user_ad');
            } else {
                $msg = $this->template->findBySlug('pending_ad');
            }
            if (!is_null($msg) and $msg->isactive == 1) {
                $msg = $msg->getMessage($ad);
                $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
                $msg = rawurlencode($msg);
                $this->sms->sendSMS($msg, $phone);
                $this->log->createLog($phone, $msg, $ad);
            }
        }
    }
}
