<?php namespace Visiosoft\SmsModule\Listeners;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\BookingModule\Booking\Events\ActivationBooking;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class activationBookingSMS
{

    private $user;
    private $template;
    private $log;

    public function __construct(
        UserRepositoryInterface $user,
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->netgsm = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->user = $user;
        $this->template = $template;
        $this->log = $log;

    }

    public function handle(ActivationBooking $event)
    {
        $sms_service_type = setting_value('visiosoft.module.sms::selected_service');


        $booking_start = date("Y/m/d H:i", strtotime($event->detail()->booking_datetime_start));
        $booking_end = date("H:i", strtotime($event->detail()->booking_datetime_end));


        $booking_detail = $event->detail()->toArray();

        $booking_detail = array_merge($booking_detail, [
            'url' => url('/booking/activated?booking_id=' . $event->getHashID() . "&activation_code=" . $booking_detail['activation_code']),
            'service' => $event->service()->name,
            'location' => $event->location()->name,
            'staff' => $event->staff()->name,
            'date' => $booking_start . "-" . $booking_end,
        ]);

        if ($template = $this->template->findBySlug(str_slug('Reservation activation', '_'))) {
            $template = $template->getTemplateForArray($booking_detail);

            if (!is_null($template) and $template['isactive'] == 1 and !is_null($booking_detail['phone'])) {
                $msg = $template['message'];
                try {
                    $this->{$sms_service_type}->sendSMS($msg, $booking_detail['phone']);
                    $this->log->createLog($booking_detail['phone'], $msg, $event->detail());
                } catch (\Exception $e) {}
            }
        }
    }
}
