<?php namespace Visiosoft\SmsModule\Listeners;

use Visiosoft\ImportModule\Events\SendPasswordSMS;
use Visiosoft\SmsModule\Log\Contract\LogRepositoryInterface;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;

class PasswordSMS
{
    private $sms;
    private $log;
    private $template;

    public function __construct(
        LogRepositoryInterface $log,
        TemplateRepositoryInterface $template)
    {
        $this->sms = app(\Visiosoft\NetgsmModule\Http\Controller\NetgsmController::class);
        $this->log = $log;
        $this->template = $template;
    }

    public function handle(SendPasswordSMS $event)
    {
        $user = $event->user();
        if ($phone = $user->gsm_phone) {
            $userArray = $user->toArray();
            $userArray['password'] = $event->password();

            if (($template = $this->template->findBySlug('forgot_password_sms')) && $template->isactive) {
                $template = $template->getTemplateForArray($userArray);
                $msg = $template['message'];
                $msg = html_entity_decode($msg, ENT_COMPAT, "UTF-8");
                $msg = rawurlencode($msg);
                $this->sms->sendSMS($msg, $phone);
                $this->log->createLog($phone, $msg, $user);
            }
        }
    }
}
