<?php namespace Visiosoft\SmarteyeModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\SmarteyeModule\Detect\Contract\DetectRepositoryInterface;
use Visiosoft\SmarteyeModule\Detect\DetectRepository;
use Anomaly\Streams\Platform\Model\Smarteye\SmarteyeDetectEntryModel;
use Visiosoft\SmarteyeModule\Detect\DetectModel;

class SmarteyeModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'api/smarteye/detect/upload' => 'Visiosoft\SmarteyeModule\Http\Controller\ApiController@uploadImage',
        'api/smarteye/detect/list' => 'Visiosoft\SmarteyeModule\Http\Controller\ApiController@listImages',
    ];

    protected $bindings = [
        SmarteyeDetectEntryModel::class => DetectModel::class,
    ];

    protected $singletons = [
        DetectRepositoryInterface::class => DetectRepository::class,
    ];
}
