<?php namespace Visiosoft\SmarteyeModule\Detect;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;
use Visiosoft\SmarteyeModule\Detect\Commands\Base64ToImage;

class DetectApiCollection extends DetectRepository
{
    use DispatchesJobs;

    public function addImage(array $params)
    {
        $this->dispatch(New CheckRequiredParams(['image', 'description'], $params));

        $file = $this->dispatch(new Base64ToImage($params['image']));

        if (!$file) {
            throw new \Exception(trans('module::message.error_image'));
        }

        $entry = $this->create([
            'image_url' => $file,
            'description' => $params['description']
        ]);

        return collect([['message' => trans('module::message.success_upload'), 'data' => [
            'image_url' => $entry->image_url,
            'description' => $entry->description
        ]]]);
    }

    public function getUploaded()
    {
        return $this->newQuery()
            ->select(['image_url', 'description','id']);
    }

    public function detail()
    {
        return $this->newQuery()->select(['id', 'image_url', 'description']);
    }

}
