<?php namespace Visiosoft\SmarteyeModule\Detect\Commands;

use Anomaly\FilesModule\File\FileSynchronizer;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use League\Flysystem\MountManager;

class Base64ToImage
{
    protected $base64;

    public function __construct($base64)
    {
        $this->base64 = $base64;
    }

    public function handle()
    {
        $base64 = $this->base64;

        $folderRepository = app(FolderRepositoryInterface::class);
        $mountManager = app(MountManager::class);
        $synchronizer = app(FileSynchronizer::class);

        $folder = $folderRepository->findBy('slug', 'images')->first();

        $data = explode(',', $base64);
        $prefix = explode('/', $data[0]);
        $prefix = explode(';', $prefix[1]);
        $prefix = $prefix[0];

        $fileName = time() . '_' . uniqid() . '.' . $prefix;

        $output_file = storage_path() . '/streams/default/files-module/' . $folder->getDisk()->getSlug() . '/'
            . $folder->getSlug() . '/' . $fileName;

        $this->base64ToJpeg($base64, $output_file);
        $file = url('/files/' . $folder->getSlug() . '/' . $fileName);
        $resource = $mountManager->get($folder->path($fileName));
        $synchronizer->sync($resource, $folder->getDisk());

        return $file;
    }

    protected function base64ToJpeg($base64_string, $output_file)
    {
        $ifp = fopen($output_file, 'wb');
        $data = explode(',', $base64_string);
        fwrite($ifp, base64_decode($data[1]));
        fclose($ifp);
        return $output_file;
    }
}