"use strict";

var dashboardWidgets = function () {

    var year_tax = function () {
        var element = document.getElementById("year_tax");
        var height = parseInt(KTUtil.css(element, 'height'));

        if (!element) {
            return;
        }

        var options = {
            series: [40, 55, 70, 80],
            chart: {
                height: height,
                type: 'radialBar',
            },
            plotOptions: {
                radialBar: {
                    hollow: {
                        margin: 0,
                        size: "55%"
                    },
                    dataLabels: {
                        showOn: "always",
                        name: {
                            show: true,
                            fontWeight: "700",
                        },
                        value: {
                            color: '#bdb8c4',
                            fontSize: "18px",
                            fontWeight: "700",
                            offsetY: 10,
                            show: true
                        },
                        total: {
                            show: true,
                            label: 'Toplam',
                            fontWeight: "bolder",
                            // formatter: function (w) {
                            //     // By default this function returns the average of all series. The below is just an example to show the use of custom formatter function
                            //     return '60%';
                            // }
                        }
                    },
                    track: {
                        background: KTApp.getSettings()['colors']['gray']['gray-100'],
                        strokeWidth: '100%'
                    }
                }
            },
            colors: [
                '#0895df',
                '#a237b9',
                '#f18233',
                '#1bc328'
            ],
            stroke: {
                lineCap: "round",
            },
            labels: ["2020","2019","2018","2017"]
        };

        var chart = new ApexCharts(element, options);
        chart.render();
    }
    var pending_tax = function () {
        var element = document.getElementById("pending_tax");
        var height = parseInt(KTUtil.css(element, 'height'));

        if (!element) {
            return;
        }

        var options = {
            series: [74],
            chart: {
                height: height,
                type: 'radialBar',
                offsetY: 0
            },
            plotOptions: {
                radialBar: {
                    startAngle: -90,
                    endAngle: 90,

                    hollow: {
                        margin: 0,
                        size: "70%"
                    },
                    dataLabels: {
                        showOn: "always",
                        name: {
                            show: true,
                            fontSize: "13px",
                            fontWeight: "700",
                            offsetY: -5,
                            color: KTApp.getSettings()['colors']['gray']['gray-500']
                        },
                        value: {
                            color: KTApp.getSettings()['colors']['gray']['gray-700'],
                            fontSize: "30px",
                            fontWeight: "700",
                            offsetY: -40,
                            show: true
                        }
                    },
                    track: {
                        background: KTApp.getSettings()['colors']['theme']['light']['primary'],
                        strokeWidth: '100%'
                    }
                }
            },
            colors: ['#f25767'],
            stroke: {
                lineCap: "round",
            },
            labels: ["Bekleyen Ödeme"]
        };

        var chart = new ApexCharts(element, options);
        chart.render();
    }


    return {
        init: function () {
            year_tax();
            pending_tax();
        }
    }
}();

// Webpack support
if (typeof module !== 'undefined') {
    module.exports = dashboardWidgets;
}

jQuery(document).ready(function () {
    dashboardWidgets.init();
});
