<?php namespace Visiosoft\SmartaxWidgetExtension;

use Anomaly\DashboardModule\Dashboard\Contract\DashboardRepositoryInterface;
use Anomaly\DashboardModule\Widget\Contract\WidgetRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Dashboard\DashboardWidgetsEntryTranslationsModel;

class SmartaxWidgetExtensionSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(
        WidgetRepositoryInterface $widgetRepository,
        DashboardRepositoryInterface $dashboardRepository,
        DashboardWidgetsEntryTranslationsModel $widgetsEntryTranslationsModel
    )
    {
        $smartaxWidget = $widgetRepository->findBy('extension', 'visiosoft.extension.smartax_widget');
        if ($smartaxWidget) {
            $widgetsEntryTranslationsModel->newQuery()->where('entry_id', $smartaxWidget->id)->delete();
            $smartaxWidget->forceDelete();
        }

        $dashboard = $dashboardRepository->findBy('slug', 'welcome');
        if (is_null($dashboard)) {
            $dashboard = $dashboardRepository->create([
                'name' => 'Welcome',
                'slug' => 'welcome',
                'description' => 'This is the default dashboard.',
                'layout'      => '24'
            ]);
        }

        $widgetRepository->create([
            'title' => '',
            'extension'   => 'visiosoft.extension.smartax_widget',
            'dashboard'   => $dashboard->id,
            'pinned'   => true,
        ]);
    }
}