"use strict";

var dashboardWidgets = function () {

    var year_tax = function () {
        var element = document.getElementById("year_tax");
        var height = parseInt(KTUtil.css(element, 'height'));

        if (!element) {
            return;
        }

        var options = {
            states: {
                hover: {
                    filter: {
                        type: 'darken',
                        value: 0.70,
                    }
                },
            },
            series: [40, 55, 70, 80],
            chart: {
                height: height,
                type: 'radialBar',
            },
            plotOptions: {
                radialBar: {
                    hollow: {
                        margin: 0,
                        size: "50%"
                    },
                    dataLabels: {
                        showOn: "always",
                        name: {
                            show: true,
                            fontWeight: "700",
                        },
                        value: {
                            color: '#BCB7C3',
                            fontSize: "16px",
                            fontWeight: "400",
                            offsetY: 10,
                            show: true,
                            formatter: function (w) {
                                if(w == 80)
                                {
                                    return '3,890,500₺';
                                }
                                return "0 ₺";
                            }
                        },
                        total: {
                            show: true,
                            label: 'Toplam',
                            fontWeight: "bold",
                            color: "#5E6278",
                            fontSize: "20px",
                            formatter: function (w) {
                                return '3,890,500₺';
                            }
                        }
                    },
                    track: {
                        background: KTApp.getSettings()['colors']['gray']['gray-100'],
                        strokeWidth: '100%'
                    }
                }
            },
            colors: [
                '#D7D4DB',
                '#D7D4DB',
                '#D7D4DB',
                '#1BC328'
            ],
            labels: ["2018","2019","2020","2021"]
        };

        var chart = new ApexCharts(element, options);
        chart.render();
    }
    var pending_tax = function () {
        var element = document.getElementById("pending_tax");
        var height = parseInt(KTUtil.css(element, 'height'));

        if (!element) {
            return;
        }

        var options = {
            series: [74],
            chart: {
                height: height,
                type: 'radialBar',
                offsetY: 0
            },
            plotOptions: {
                radialBar: {
                    startAngle: -90,
                    endAngle: 90,

                    hollow: {
                        margin: 0,
                        size: "70%"
                    },
                    dataLabels: {
                        showOn: "always",
                        name: {
                            show: true,
                            fontSize: "13px",
                            fontWeight: "700",
                            offsetY: -5,
                            color: KTApp.getSettings()['colors']['gray']['gray-500']
                        },
                        value: {
                            color: KTApp.getSettings()['colors']['gray']['gray-700'],
                            fontSize: "30px",
                            fontWeight: "700",
                            offsetY: -40,
                            show: true
                        }
                    },
                    track: {
                        background: "#FCDDE1",
                        strokeWidth: '100%'
                    }
                }
            },
            colors: ['#f25767'],
            stroke: {
                lineCap: "round",
            },
            labels: ["Bekleyen Ödeme"]
        };

        var chart = new ApexCharts(element, options);
        chart.render();
    }


    return {
        init: function () {
            year_tax();
            pending_tax();
        }
    }
}();

// Webpack support
if (typeof module !== 'undefined') {
    module.exports = dashboardWidgets;
}

jQuery(document).ready(function () {
    dashboardWidgets.init();
});
