<?php namespace Visiosoft\SmartaxModule;

use Anomaly\Streams\Platform\Addon\Module\Module;
use Illuminate\Filesystem\Filesystem;

class SmartaxModule extends Module
{
    protected $navigation = true;

    protected $sections = [
        'smartax' => [
            'href' => 'admin/smartax'
        ]
    ];

    public function onInstalling(Filesystem $files)
    {
        // Backup Old package.json
        $files->put(base_path('package.json_old'), file_get_contents(base_path('package.json')));

        // Backup Old webpack.mix.js
        $files->put(base_path('webpack-old.mix.js'), file_get_contents(base_path('webpack.mix.js')));

        // Update
        $package_json = file_get_contents(__DIR__ . "/../package.json");
        $webpack = file_get_contents(__DIR__ . "/../webpack.mix.js");

        $files->put(base_path('package.json'), $package_json);
        $files->put(base_path('package.json'), $webpack);
    }

}
