<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Support\Authorizer;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\SmartaxModule\Feature\Contract\FeatureRepositoryInterface;
use Visiosoft\SmartaxModule\Services\Mapilio;
use Visiosoft\SmartaxModule\SettingForm\SettingFormBuilder;
use Visiosoft\SmartaxModule\SmartaxExport;
use Visiosoft\SmartaxModule\User\Form\UserFormBuilder;
use Visiosoft\SmartaxModule\User\Table\UserTableBuilder;

class SmartaxController extends AdminController
{
    protected $authorizer;

    public function __construct(Authorizer $authorizer)
    {
        $this->authorizer = $authorizer;
        parent::__construct();
    }

    public function dashboard(FeatureRepositoryInterface $featureRepository)
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.dashbaord')) {
            abort(403);
        }

        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Gösterge Paneli', '#');

        $class = "inst-sign-store";
        $project_key = setting_value('visiosoft.module.smartax::project_key');
        $organization_key = setting_value('visiosoft.module.smartax::organization_key');
        $token = setting_value('visiosoft.module.smartax::token');
        $max_area = number_format(setting_value('visiosoft.module.smartax::max-area', '20.0'));
        $min_area = number_format(setting_value('visiosoft.module.smartax::min-area', '3.0'));
        $mapilioApi = new Mapilio($token, $organization_key, $project_key);

        $mapilioApi->getTotalKM();
        $total_km = $mapilioApi->getResponseValue('total_km');

        $mapilioApi->setOtherParams([
            'filter_class_code' => $class,
            'filter_area_min' => $min_area,
            'filter_area_max' => $max_area
        ]);

        $mapilioApi->getTotalArea();
        $total_area = $mapilioApi->getResponseValue('total');

        $mapilioApi->getTotalFeature();
        $total_object = $mapilioApi->getResponseValue('total');

        $total_price = setting_value('visiosoft.module.smartax::tax-price') * ($total_area);
        $total_price = number_format($total_price, 2, ',', '.');

        return view('module::admin.dashboard', compact('total_km', 'total_object', 'total_price', 'min_area', 'max_area'));
    }

    public function report()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Rapor Oluştur', '#');

        return view('module::admin.report');
    }

    public function settings(SettingFormBuilder $builder)
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.settings')) {
            abort(403);
        }

        return $builder->render();
    }

    public function taxpayerList()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Tabela Listesi', '#');

        return view('module::admin.list');
    }

    public function map()
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.map')) {
            abort(403);
        }

        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Harita', '#');

        $neighborhoods = DB::table('bsk_mahalle')
            ->select('ad', 'id')
            ->get();


        if (request()->view === 'vertical') {
            return view('module::admin/map-vertical', compact('neighborhoods'));
        } else {
            return view('module::admin/map', compact('neighborhoods'));
        }
    }

    public function detail($id)
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.detail')) {
            abort(403);
        }

        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Harita', '/admin/smartax/map');
        $this->breadcrumbs->add('Mükellef Detay', '#');

        $next_id = intval($id) + 1;

        return $this->view->make('module::admin/detail', compact('id', 'next_id'));
    }

    public function edit($id)
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.edit')) {
            abort(403);
        }

        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');

        $this->breadcrumbs->add('Harita', '/admin/smartax/map');
        $this->breadcrumbs->add('Mükellef Detay', route('visiosoft.module.smartax::detail', ['id' => $id]));
        $this->breadcrumbs->add('Mükellef Tabela Düzenle', '#');

        return $this->view->make('module::admin/edit', compact('id'));
    }

    public function users(UserTableBuilder $table)
    {
        return $table->render();
    }

    public function createUser(UserFormBuilder $builder)
    {
        return $builder->render();
    }

    public function editUser(UserFormBuilder $builder, $id)
    {
        return $builder->render($id);
    }

    public function downloadReport()
    {
        try {
            $token = setting_value('visiosoft.module.smartax::token');
            $filters = array();

            if (request()->get('min-filter')) {
                $filters['filter_area_min'] = $this->request->get('min-filter');
            }

            if (request()->get('max-filter')) {
                $filters['filter_area_max'] = $this->request->get('max-filter');
            }

            if (request()->get('neighborhood')) {
                $filters['filter_neighborhood'] = $this->request->get('neighborhood');
            }

            if (request()->get('road')) {
                $filters['filter_road'] = $this->request->get('road');
            }

            $mapilioApi = new Mapilio($token);
            $mapilioApi->setOrder('DESC');
            $mapilioApi->setPage(1);
            $mapilioApi->setLimit(999999);
            $mapilioApi->setOtherParams($filters);

            $result = $mapilioApi->getFeatures();

            return Excel::download(new SmartaxExport($result->getData()), 'smartax-report-' . time() . '.xlsx');
        } catch (\Exception $exception) {
            abort(500);
        }
    }

    public function deleteFeature($id)
    {
        try {
            $token = setting_value('visiosoft.module.smartax::token');

            $mapilioApi = new Mapilio($token);
            $mapilioApi->deleteFeature($id);

            if ($mapilioApi->response()['status']) {
                $this->messages->success(['Veri Silindi!']);
            } else {
                $this->messages->error(['Teknik bir sorun oluştu!']);
            }

        } catch (\Exception $exception) {
            $this->messages->error(['Teknik bir sorun oluştu!']);
        }

        return $this->redirect->to('/admin/smartax/map');
    }
}
