<?php namespace Visiosoft\SmartaxModule\Commands;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\DB;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;
use Visiosoft\SmartaxModule\SequenceDetail\Contract\SequenceDetailRepositoryInterface;

class SyncMapilioPoints
{
    protected $token;

    public function __construct($token)
    {
        $this->token = $token;
    }

    public function handle(
        SequenceDetailRepositoryInterface $sequenceDetailRepository,
        PointRepositoryInterface          $pointRepository
    )
    {
        $entries = $sequenceDetailRepository->newQuery()
            ->where('sync_detail', true)
            ->where('sync_points', false)
            ->orderBy('id')
            ->limit(1)
            ->get();

        $counter = 0;

        foreach ($entries as $entry) {

            // Get Points With CURL Service
            $points = $this->getPoints($entry->sequence_uuid);

            // Save Points
            foreach ($points as $item) {

                $is_points = $pointRepository->newQuery()
                    ->where('photo_uuid', $item['photo_uuid'])
                    ->first();

                if (!$is_points) {

                    /**
                     * Save Point
                     */
                    $point = $pointRepository->newQuery()
                        ->create([
                            'lat' => $item['lat'],
                            'lon' => $item['lon'],
                            'heading' => $item['heading'],
                            'altitude' => $item['altitude'],
                            'orientation' => $item['orientation'],
                            'filename' => $item['filename'],
                            'device_make' => $item['device_make'],
                            'device_model' => $item['device_model'],
                            'sequence_uuid' => $item['sequence_uuid'],
                            'uploaded_hash' => $item['uploaded_hash'],
                            'photo_uuid' => $item['photo_uuid'],
                            'resolution' => $item['resolution'],
                            'fov' => $item['fov'],
                            'anomaly' => $item['anomaly'],
                            'data_created_by_id' => $item['data_created_by_id'],
                            'capture_time' => $item['capture_time'],
                        ]);

                    // Geom Save (Point)
                    DB::statement("UPDATE default_smartax_point
	                                        SET  geom=ST_GeomFromGeoJSON('" . json_encode($item['geom']) . "')
	                                        WHERE id=" . $point->id . ";");

                    $counter++;
                }
            }

            $entry->setAttribute('sync_points', true);
            $entry->save();
        }

        return [
            'counter' => $counter
        ];
    }

    public function getPoints($uuid)
    {
        $points = $this->newRequest($this->token, $uuid);

        return $points;
    }

    public function newRequest($token, $uuid)
    {
        try {
            $url = setting_value('visiosoft.module.smartax::mapilio_sync_url') . "/api/points/listBySequence" . '?' . http_build_query([
                    'token' => $token,
                    'sequence_uuid' => $uuid,
                ]);

            $client = new Client([
                'cookies' => true,
                'http_errors' => false,
                'verify' => false
            ]);

            $response = $client->request('GET', $url);

            $response = $response->getBody()->getContents();


            $response = json_decode($response, true);

            if (!$response['status']) {
                throw new \Exception([$response['message']]);
            }

            return $response['response'];

        } catch (\Exception $exception) {
            throw new \Exception(["The incoming data is not correct."]);
            die;
        }
    }
}