"use strict";

var dashboardWidgets = function () {

    var year_tax = function () {
        var element = document.getElementById("year_tax");
        var height = parseInt(KTUtil.css(element, 'height'));
        let series = getSeries();


        if (!element) {
            return;
        }

        function getSeries() {
            let entries = [];
            crudAjax('', '/api/smartax/chart-year', 'GET', function (r) {

                $.each(r.data, function (index, value) {
                    entries.push(parseFloat(parseFloat(value.total_area).toFixed(2) * parseFloat(r.area_price, 2)));
                });

            });
            return entries;
        };

        var options = {
            states: {
                hover: {
                    filter: {
                        type: 'darken',
                        value: 0.70,
                    }
                },
            },
            series: series,
            chart: {
                height: height,
                type: 'radialBar',
            },
            plotOptions: {
                radialBar: {
                    hollow: {
                        margin: 0,
                        size: "50%"
                    },
                    dataLabels: {
                        showOn: "always",
                        name: {
                            show: true,
                            fontWeight: "700",
                        },
                        value: {
                            color: '#BCB7C3',
                            fontSize: "16px",
                            fontWeight: "400",
                            offsetY: 10,
                            show: true,
                            formatter: function (w) {
                                return parseFloat(w).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + "₺";
                            }
                        },
                        total: {
                            show: true,
                            label: 'Toplam',
                            fontWeight: "bold",
                            color: "#5E6278",
                            fontSize: "20px",
                            formatter: function (w) {
                                var total = parseFloat(0);
                                for (var i in w.config.series) {
                                    total += parseFloat(w.config.series[i]);
                                }
                                return total.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') + "₺";
                            }
                        }
                    },
                    track: {
                        background: KTApp.getSettings()['colors']['gray']['gray-100'],
                        strokeWidth: '100%'
                    }
                }
            },
            colors: [
                '#D7D4DB',
                '#D7D4DB',
                '#D7D4DB',
                '#1BC328'
            ],
            labels: ["2018", "2019", "2020", "2021"]
        };

        var chart = new ApexCharts(element, options);
        chart.render();
    }
    var pending_tax = function () {
        var element = document.getElementById("pending_tax");
        var height = parseInt(KTUtil.css(element, 'height'));

        if (!element) {
            return;
        }

        var options = {
            series: [100],
            chart: {
                height: height,
                type: 'radialBar',
                offsetY: 0
            },
            plotOptions: {
                radialBar: {
                    startAngle: -90,
                    endAngle: 90,

                    hollow: {
                        margin: 0,
                        size: "70%"
                    },
                    dataLabels: {
                        showOn: "always",
                        name: {
                            show: true,
                            fontSize: "13px",
                            fontWeight: "700",
                            offsetY: -5,
                            color: KTApp.getSettings()['colors']['gray']['gray-500']
                        },
                        value: {
                            color: KTApp.getSettings()['colors']['gray']['gray-700'],
                            fontSize: "30px",
                            fontWeight: "700",
                            offsetY: -40,
                            show: true
                        }
                    },
                    track: {
                        background: "#FCDDE1",
                        strokeWidth: '100%'
                    }
                }
            },
            colors: ['#f25767'],
            stroke: {
                lineCap: "round",
            },
            labels: ["Bekleyen Ödeme"]
        };

        var chart = new ApexCharts(element, options);
        chart.render();
    }

    return {
        init: function () {
            year_tax();
            pending_tax();
        }
    }
}();

// Webpack support
if (typeof module !== 'undefined') {
    module.exports = dashboardWidgets;
}

jQuery(document).ready(function () {
    dashboardWidgets.init();
});

// İframe yüklendikten sonra çalışacak kod
window.onload = function() {
    // İframe elemanını al
    var iframe = document.getElementById("street-view");

    // İframe yüklenme durumunu kontrol et
    iframe.addEventListener("load", function() {
        // İframe içeriğine eriş
        var iframeContent = iframe.contentDocument || iframe.contentWindow.document;

        // "mapPointClicked" etkinliğini dinle
        iframeContent.addEventListener("mapPointClicked", function(event) {
            // Etkinlik gerçekleştiğinde buradaki kod çalışır
            console.log("mapPointClicked etkinliği gerçekleşti.");
            console.log("Etkinlik verisi:", event.detail);
            alert(333);
        });
    });

    // iframe henüz yüklenmediyse, hata mesajı yazdır
    iframe.onerror = function() {
        console.error("İframe yüklenirken bir hata oluştu.");
    };
};