<?php

return [
    'api_url' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'https://api.mapilio.com',
        ],
    ],
    'image_server_url' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'https://cdn.mapilio.com',
        ],
    ],
    'calculation_check_time' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 5000,
            'min' => 2000,
            'max' => 10000,
        ],
    ],
    'mapilio_sync_url' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'https://end.mapilio.com',
        ],
    ],
    'project_key' => [
        'type' => 'anomaly.field_type.text',
        'bind' => 'visiosoft.module.smartax::project_key',
    ],
    'organization_key' => [
        'type' => 'anomaly.field_type.text',
        'bind' => 'visiosoft.module.smartax::organization_key',
    ],
    'token' => [
        'type' => 'anomaly.field_type.text',
        'bind' => 'visiosoft.module.smartax::token',
    ],
    'tax-price' => [
        'type' => 'anomaly.field_type.decimal',
        'bind' => 'visiosoft.module.smartax::tax-price',
    ],
    'min-area' => [
        'type' => 'anomaly.field_type.decimal',
        'bind' => 'visiosoft.module.smartax::min-area',
        'config' => [
            "default_value" => '3.0',
        ],
    ],
    'max-area' => [
        'type' => 'anomaly.field_type.decimal',
        'bind' => 'visiosoft.module.smartax::max-area',
        'config' => [
            "default_value" => '20.0',
        ],
    ],
];
