<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


class VisiosoftModuleSmartaxCreateObjectInformationTable extends Migration
{
    public function up()
    {
        $schema = app('db')->connection()->getSchemaBuilder();

        $schema->create(
            'smartax_object_information',
            function (Blueprint $table) {
                $table->increments('id');
                $table->integer('object_id');
                $table->string('neighborhood', 255);
                $table->string('road', 255);
                $table->string('door', 255);
                $table->decimal('area', 255);
                $table->string('lon', 255);
                $table->string('lat', 255);
                $table->string('name', 255);
            });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('smartax_object_information');
    }
}
