<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSmartaxCreateSequenceDetailStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'sequence_detail',
        'title_column' => 'sequence_uuid',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'sequence_uuid' => 'anomaly.field_type.text',
        'count' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 0
            ],
        ],
        'size' => [
            'type' => 'anomaly.field_type.decimal',
            'config' => [
                'default_value' => 0
            ],
        ],
        'anomaly' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
        'length_km' => 'anomaly.field_type.decimal',
        'sync_detail' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
        'sync_points' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
        'sync_features' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'sequence_uuid' => [
            'required' => true,
        ],
        'count',
        'size',
        'anomaly',
        'length_km',
        'sync_detail',
        'sync_points',
        'sync_features',
    ];

}
